﻿using System.Windows;
using System.Windows.Media;
using System.Windows.Controls.Primitives;

namespace Chapter20
{
    public class PlayingCard : ToggleButton
    {
        static PlayingCard()
        {
            // Zamiana stylu
            DefaultStyleKeyProperty.OverrideMetadata(typeof(PlayingCard),
                new FrameworkPropertyMetadata(typeof(PlayingCard)));

            // Rejestrowanie właściwości zależnej Face
            FaceProperty = DependencyProperty.Register("Face",
                typeof(string), typeof(PlayingCard));
        }

        public string Face
        {
            get { return (string)GetValue(FaceProperty); }
            set { SetValue(FaceProperty, value); }
        }

        public static DependencyProperty FaceProperty;
    }
}