#ifndef MAZE_H
#define MAZE_H

#include <vector>
#include "path.h"

using namespace std;

/**
   Labirynt, którego ściany są oznaczone znakami *, a korytarze 
   spacjami. Pozycje korytarza mogą być sklasyfikowane jako ślepe końce,
   skrzyżowania lub wyjścia, a drogi można przedłużać od 
   od jednego skrzyżowania do drugiego. Zakłada się, że w labiryncie nie ma
   cykli (tzn. dróg wiodących z powrotem do punktu startowego.)
*/
class Maze
{
public:
   /**
      Konstruuje labirynt z ciągów opisujących jego wnętrze.
      @param contents ciągi składające się ze znaków * i spacji
   */
   Maze(const vector<string>& contents);

   /**
      Pobiera wszystkie drogi odchodzące z danej pozycji labiryntu.
      @param row wiersz pozycji
      @param column kolumna pozycji
      @return wszystkie drogi odchodzące z danej pozycji
   */
   vector<Path> paths_from(int row, int column) const;

   /**
      Sprawdza, czy dana pozycja stanowi wyjście.
      @param row wiersz pozycji
      @param column kolumna pozycji
      @return wartość true, jeśli pozycja stanowi wyjście
   */
   bool is_exit(int row, int column) const;

   /**
      Sprawdza, czy dana pozycja to ślepy koniec.
      @param row wiersz pozycji
      @param column kolumna pozycji
      @return wartość true, jeśli pozycja to ślepy koniec
   */
   bool is_dead_end(int row, int column) const;

 private:
   /**
      Przedłuża drogę do najbliższego wyjścia, skrzyżowania, lub ślepego końca.
      @param p droga do przedłużenia
   */
   void extend(Path& p) const;
   /**
      Sprawdza, czy pozycja znajduje się w obrębie labiryntu i nie jest ścianą.
      @param row wiersz pozycji
      @param column kolumna pozycji
      @return wartość true, jeśli pozycja jest poprawna
   */
   bool is_valid(int row, int column) const;

   /**
      Podaje liczbę pozycji sąsiadujących z bieżącą.
      @param row wiersz pozycji
      @param column kolumna pozycji
      @return liczba sąsiednich pozycji w czterech głównych kierunkach geograficznych
      które znajdują się w obrebie labiryntu i nie są ścianami
   */
   int count_neighbors(int row, int column) const;

   vector<string> cells;
};

#endif

