#include <cstdlib>
#include <ctime>
#include <iostream>

using namespace std;

/**
    Pobiera pozycję najmniejszego elementu w pewnym zakresie tablicy.
    @param a tablica
    @param from początek zakresu
    @param to koniec zakresu
    @return pozycja najmniejszego elementu
    w zakresie a[from]...a[to]
*/
int min_position(int a[], int from, int to)
{
   int min_pos = from;
   for (int i = from + 1; i <= to; i++)
   {
      if (a[i] < a[min_pos]) { min_pos = i; }
   }
   return min_pos;
}

/**
   Zamienia miejscami dwie liczby całkowite.
   @param x pierwsza liczba całkowita do zamiany
   @param y druga liczba całkowita do zamiany
*/
void swap(int& x, int& y)
{
   int temp = x;
   x = y;
   y = temp;
}

/**
   Sortuje tablicę przy użyciu algorytmu sortowania przez wybieranie.
   @param a tablica do posortowania
   @param size liczba elementów tablicy a
*/
void selection_sort(int a[], int size)
{
   int next; // Następna pozycja, do której trafi najmniejsza liczba

   for (next = 0; next < size - 1; next++)
   {
      // Znajdź pozycję najmniejszej liczby, począwszy od indeksu next.
      int min_pos = min_position(a, next, size - 1);
      // Zamień miejscami element na pozycji next i najmniejszą liczbę.
      swap(a[next], a[min_pos]);
   }
}

/**
   Wyświetla wszystkie elementy tablicy.
   @param a tablica do wyświetlenia
   @param size liczba elementów tablicy a
*/
void print(int a[], int size)
{
   for (int i = 0; i < size; i++)
   {
      cout << a[i] << " ";
   }
   cout << endl;
}

int main()
{
   srand(time(0));
   const int SIZE = 20;
   int values[SIZE];
   for (int i = 0; i < SIZE; i++)
   {
      values[i] = rand() % 100;
   }
   print(values, SIZE);
   selection_sort(values, SIZE);
   print(values, SIZE);
   return 0;
}

