#include <iostream>
#include <string>
#include <vector>

using namespace std;

/**
   Menu wyświetlane w konsoli.
*/
class Menu
{
public:
   /**
      Konstruuje menu bez opcji.
   */
   Menu();

   /**
      Dodaje opcję na końcu menu.
      @param option dodawana opcja
   */
   void add_option(string option);

   /**
      Wyświetla menu z opcjami ponumerowanymi od 1
      i monituje użytkownika o dane wejściowe.
      Powtarza te działania do chwili podania poprawnych danych.
      @return liczba podana przez użytkownika
   */
   int get_input() const;
private:
   void display() const;

   vector<string> options;
};

Menu::Menu()
{
}

void Menu::add_option(string option)
{
   options.push_back(option);
}

void Menu::display() const
{
   for (int i = 0; i < options.size(); i++)
   {
      cout << i + 1 << ") " << options[i] << endl;
   }
}

int Menu::get_input() const
{
   int input;
   do
   {
      display();
      cin >> input;
   }
   while (input < 1 || input > options.size());
   return input;
}

int main()
{
   Menu main_menu;
   main_menu.add_option("Załóż nowe konto");
   main_menu.add_option("Zaloguj się na istniejące konto");
   main_menu.add_option("Pomoc");
   main_menu.add_option("Wyjście");
   int input = main_menu.get_input();
   cout << "Wybór: " << input << endl;
   return 0;
}

