#include <cstdlib>
#include <ctime>
#include <iostream>
#include <algorithm>

#include "shellsort.h"

using namespace std;

/**
   Wypełnia tablicę losowymi liczbami całkowitymi od 0 do 99.
   @param a tablica do wypełnienia
   @param size liczba elementów w tablicy a
*/
void random_fill(int a[], int size)
{
   for (int i = 0; i < size; i++)
   {
      a[i] = rand() % 100;
   }
}

/**
   Wyświetla wszystkie elementy tablicy.
   @param a tablica do wyświetlenia
   @param size liczba elementów w tablicy a
*/
void print(int a[], int size)
{
   for (int i = 0; i < size; i++)
   {
      cout << a[i] << " ";
   }
   cout << endl;
}

const int MAX_SIZE = 5000000;
int values[MAX_SIZE];

int main()
{
   srand(time(0));
   int size = 20;

   cout << "Demonstracja przy " << size << " elementach:" << endl;
   random_fill(values, size);
   print(values, size);
   shell_sort(values, size);
   print(values, size);
   cout << "Wprowadź rozmiar tablicy: ";
   cin >> size;
   const int ITERATIONS = 1000;

   int before = time(0);
   srand(before);
   for (int i = 1; i <= ITERATIONS; i++)
   {
      random_fill(values, size);
      shell_sort(values, size);
   }
   int after = time(0);
   cout << "Czas wykonania przy użyciu sortowania Shella: "
      << (after - before) * 1.0 / ITERATIONS << " sekund(y)" << endl;

   srand(before); // Upewnij się, że dostaniemy z powrotem te same tablice.
   before = time(0);
   for (int i = 1; i <= ITERATIONS; i++)
   {
      random_fill(values, size);
      sort(values, values + size);
   }
   after = time(0);
   cout << "Czas wykonania przy użyciu funkcji sort z biblioteki: "
      << (after - before) * 1.0 / ITERATIONS << " sekund(y)" << endl;

   const int ITERATIONS2 = 10;
   before = time(0);
   for (int i = 1; i <= ITERATIONS2; i++)
   {
      random_fill(values, size);
   insertion_sort(values, size, 0, 1);
   }
   after = time(0);
   cout << "Czas wykonania przy użyciu sortowania przez wstawianie: " << after - before
      << (after - before) * 1.0 / ITERATIONS2 << " sekund(y)" << endl;

   return 0;
}

