#include <iostream>
#include <string>
#include <vector>
#include "question.h"

class ChoiceQuestion : public Question
{
public:
   /**
      Konstruuje pytanie wyboru bez podanych odpowiedzi.
   */
   ChoiceQuestion();

   /**
      Dodaje do pytania  możliwą odpowiedź.
      @param choice dodawana odpowiedź
      @param correct wartość true, jeśli ten wybór jest  poprawny, w przeciwnym razie wartość false
   */
   void add_choice(string choice, bool correct);

   void display() const;
private:
   vector<string> choices;
};

ChoiceQuestion::ChoiceQuestion()
{
}

void ChoiceQuestion::add_choice(string choice, bool correct)
{
   choices.push_back(choice);
   if (correct)
   {
      // Skonwertuj wyrażenie choices.size() na ciąg.
      string num_str = to_string(choices.size());
      set_answer(num_str);
   }
}

void ChoiceQuestion::display() const
{
   // Wyświetl tekst pytania.
   Question::display();
   // Wyświetl możliwe odpowiedzi.
   for (int i = 0; i < choices.size(); i++)
   {
      cout << i + 1 << ": " << choices[i] << endl;      
   }
}

int main()
{
   string response;
   cout << boolalpha;

   // Zadaj podstawowe pytanie.

   Question q1;
   q1.set_text("Kto jest twórcą języka C++?");
   q1.set_answer("Bjarne Stroustrup");

   q1.display();
   cout << "Twoja odpowiedź: ";
   getline(cin, response);
   cout << q1.check_answer(response) << endl;

   // Zadaj pytanie wyboru.

   ChoiceQuestion q2;
   q2.set_text("W jakim kraju urodził się twórca języka C++?");
   q2.add_choice("Australia", false);
   q2.add_choice("Dania", true);
   q2.add_choice("Korea", false);
   q2.add_choice("Stany Zjednoczone", false);

   q2.display();
   cout << "Twoja odpowiedź: ";
   getline(cin, response);
   cout << q2.check_answer(response) << endl;   

   return 0;
}

