#ifndef CASHREGISTER_H
#define CASHREGISTER_H

/**
   Symulacja kasy fiskalnej, która liczy produkty
   i łączną sumę należności.
 */
class CashRegister
{
public:
   /**
      Konstruuje obiekt kasy fiskalnej z wyzerowaną liczbą produktów i ich łączną wartością.
   */
   CashRegister();

   /**
      Zeruje liczbę produktów i ich łączną wartość.
   */
   void clear();

   /**
      Dodaje produkt do kasy.
      @param price cena produktu
   */
   void add_item(double price);

   /**
      @return łączna wartość bieżącej transakcji
   */
   double get_total() const;

   /**
      @return liczba obecnie sprzedawanych produktów
   */
   int get_count() const;

private:
   int item_count;
   double total_price;
};

#endif

