#include <cctype>
#include <fstream>
#include <iostream>
#include <iomanip>
#include <sstream>
#include <string>

using namespace std;

/** 
   Konwertuje ciąg na liczbę zmiennoprzecinkową, np. "3.14" -> 3.14.
   @param s ciąg reprezentujący liczbę zmiennoprzecinkową
   @return równoważna liczba zmiennoprzecinkowa
*/   
double string_to_double(string s)
{
   istringstream stream;
   stream.str(s);
   double x = 0;
   stream >> x;
   return x;
}

/**
   Wyodrębnia z wiersza wejściowego kraj i skojarzoną z nim wartość.
   @param line wiersz zawierający nazwę kraju i liczbę
   @param country ciąg służący do przechowywania nazwy kraju
   @param value zmienna służąca do przechowywania skojarzonej z krajem wartości
   @return wartość true, jeśli wiersz został odczytany, wartość false na końcu strumienia
*/
void read_line(string line, string& country, double& value)
{   
   int i = 0; // Zlokalizuj początek pierwszej cyfry.
   while (!isdigit(line[i])) { i++; }
   int j = i - 1; // Zlokalizuj koniec poprzedzającego ją wyrazu.
   while (isspace(line[j])) { j--; }
      
   country = line.substr(0, j + 1); // Wyodrębnij nazwę kraju.
   value = string_to_double(line.substr(i)); // Wyodrębnij wartość liczbową.
}

int main()
{
   ifstream in1;
   ifstream in2;
   in1.open("worldpop.txt"); // Otwórz pliki wejściowe.
   in2.open("worldarea.txt");

   ofstream out;
   out.open("world_pop_density.txt"); // Otwórz plik wyjściowy.
   out << fixed << setprecision(2);

   string line1;
   string line2;

   // Odczytaj po wierszu z każdego pliku.
   while (getline(in1, line1) && getline(in2, line2))
   {
      string country;
      double population;
      double area;

      // Podziel wiersze na kraje i skojarzone z nimi wartości.
      read_line(line1, country, population);
      read_line(line2, country, area);

      // Oblicz i wypisz gęstość zaludnienia.
      double density = 0;
      if (area != 0) // Zabezpiecz przed dzieleniem przez zero.
      {
         density = population * 1.0 / area;
      }
      out << setw(40) << left << country  
         << setw(15) << right << density << endl;      
   }

   return 0;
}

