#include "picture.h"
#include <string>

using namespace std;

int main()
{
   const int MAX_WIDTH = 720;
   const int GAP = 10;
   const string names = "abcdefghijklmnopqrst";
   const int PICTURES = names.length();

   // Odczytaj pierwszy obraz.
   Picture pic("a.png");

   // Zmienne x i y to współrzędne górnego lewego rogu następnego obrazu.
   int x = pic.width() + GAP;
   int y = 0;

   // Zmienna max_y zawiera największą dotychczas wartość współrzędnej y.
   int max_y = pic.height(); 
   for (int i = 1; i < PICTURES; i++)
   {
      // Odczytaj następny obraz.
      Picture pic2(names.substr(i, 1) + ".png");
      if (x + pic2.width() >= MAX_WIDTH) // // Obraz nie mieści się w bieżącym rzędzie.
      {
         // Umieść obraz w następnym rzędzie.
         x = 0;
         y = max_y + GAP;
      }
      pic.add(pic2, x, y);
      // Zaktualizuj zmienne x i max_y
      x = x + pic2.width() + GAP;
      if (y + pic2.height() > max_y)
      {
         max_y = y + pic2.height();
      }
   }
   pic.save("gallery.png");
   return 0;
}

