#ifndef BINARY_SEARCH_TREE_H
#define BINARY_SEARCH_TREE_H

#include <string>

using namespace std;

class Node
{
private:
   string data;
   Node* left;
   Node* right;
friend class BinarySearchTree;   
};   

/*
   Klasa ta stanowi implementację binarnego drzewa poszukiwań,
   którego węzły przechowują ciągi.
*/
class BinarySearchTree
{
public:   
   /**
      Konstruuje puste drzewo.
   */
   BinarySearchTree();
   
   /**
      Wstawia do drzewa nowy węzeł.
      @param element element do wstawienia
   */
   void insert(string element);

   /**
      Próbuje znaleźć w drzewie pewien element.
      @param element element do znalezienia
      @return liczba 1, jeśli drzewo zawiera ten element
   */
   int count(string element) const;
   
   /**
      Próbuje usunąć element  z drzewa. Jeśli drzewo
      go nie zawiera, nic nie robi.
      @param element element do usunięcia
   */
   void erase(string element);
   
   /**
      Wyświetla zawartość drzewa wg porządku sortowania.
   */
   void print() const;

private:   
   /**
      Wyświetla węzeł i wszystkich jego potomków wg porządku sortowania.
      @param parent korzeń wyświetlanego poddrzewa
   */
   void print(Node* parent) const;

   /**
      Wstawia nowy węzeł jako potomka danego węzła.
      @param parent korzeń
      @param new_node węzeł do wstawienia
   */
   void add_node(Node* parent, Node* new_node) const;

   Node* root;
};

#endif

