#ifndef TREE_H

#include <vector>
#include <string>

using namespace std;

class Node
{
private:
   /**
      Oblicza rozmiar poddrzewa, którego korzeniem jest ten węzeł.
      @return liczba węzłów w poddrzewie
   */
   int size() const;

   string data;
   vector<Node*> children;
friend class Tree;   
};

/*
   Drzewo, w którym każdy węzeł ma dowolną liczbę dzieci.
*/
class Tree
{
public:
   /**
      Konstruuje puste drzewo.
   */
   Tree();

   /**
      Konstruuje drzewo z jednym węzłem i bez dzieci.
      @param root_data dane w korzeniu
   */
   Tree(string root_data);

   /**
      Dodaje poddrzewo jako ostatnie dziecko korzenia.
   */
   void add_subtree(const Tree& subtree);

   /**
      Oblicza rozmiar drzewa.
      @return liczba węzłów w drzewie
   */
   int size() const;

   // Dalsze metody będą dodawane w następnych podrozdziałach.
   
private:   
   Node* root;
};

#endif

