#include <iostream>
#include <unordered_map>
#include <utility>
#include <string>
#include <vector>

using namespace std;

/**
   Klasa TelephoneDirectory obsługuje mapę par imię/numer.
*/
class TelephoneDirectory
{
public:
   /**
      Dodaj do bazy danych nową parę imię/numer.
      @param name nowe imię
      @param number nowy numer
   */
   void add_entry(string name, int number);

   /**
      FZnajdź numer skojarzony z imieniem.
      @param name szukane imię
      @return skojarzony z imieniem numer albo zero,
      jeśli w bazie danych nie ma imienia
   */
   int find_entry(string name) const;

   /**
      Wypisz wszystkie pozycje.
   */
   void print_all() const;
private:
   unordered_map<string, int> database;
};

void TelephoneDirectory::add_entry(string name, int number)
{
   database[name] = number;
}

int TelephoneDirectory::find_entry(string name) const
{
   auto pos = database.find(name);
   if (pos == database.end())
   {
      return 0; // Nie znaleziono.
   }
   else
   {
      return pos->second;
   }
}

void TelephoneDirectory::print_all() const
{
   for (auto pos = database.begin(); pos != database.end(); pos++)
   {
      cout << pos->first << ": " << pos->second << endl;
   }
}

int main()
{
   TelephoneDirectory data;
   data.add_entry("Filip", 7235591);
   data.add_entry("Maria", 3841212);
   data.add_entry("Sylwia", 3841212);
   cout << "Numer Filipa: " << data.find_entry("Filip") << endl;
   cout << "Wszystkie imiona i numery:" << endl;
   data.print_all();
   return 0;
}

