#ifndef PATH_H
#define PATH_H

#include <string>

using namespace std;

const int NORTH = 0;
const int EAST = 1;
const int SOUTH = 2;
const int WEST = 3;

/**
   Droga w labiryncie, definiowana przez pozycję startową (wiersz, kolumna) 
   i kierunek (N - północ, E - wschód, S - południe, W - zachód).
   Na początku droga ma takie same: pozycję początkową i końcową
   oraz kierunek początkowy i końcowy. W trakcie przemierzania labiryntu może być przedłużona,
   aż doprowadzi do wyjścia, skrzyżowania lub ślepego końca. 

   Intuicyjnie można sobie wyobrazić, że droga zaczyna się od skrzyżowania
   i wiedzie naprzód, być może z zakrętami, 
   aż doprowadzi do innego skrzyżowania. 
*/
class Path
{
public:  
   /**
      Konstruuje drogę z podanej pozycji w określonym kierunku.
      @param row wiersz początkowy
      @param column kolumna początkowa
      @param direction kierunek początkowy
   */
   Path(int row, int column, int direction);

   /**
      Przesuwa pozycję końcową tej drogi o jedno pole
      w aktualnym kierunku.
   */
   void move();

   /**
      Zmienia końcowy kierunek tej drogi zgodnie z ruchem wskazówek zegara.
   */
   void turn();

   /**
      Pobiera wiersz końca tej drogi.
      @return końcowy wiersz 
   */
   int get_ending_row() const;

   /**
      Pobiera kolumnę końca tej drogi.
      @return końcowa kolumna
   */
   int get_ending_column() const;

   /**
      Pobiera następny wiersz tej drogi, jeśli prowadzi dalej
      w kierunku końcowym.
      @return następny wiersz
   */
   int get_next_row() const;

   /**
      Pobiera następną kolumnę tej drogi, jeśli prowadzi dalej
      w kierunku końcowym.
      @return następna kolumna
   */
   int get_next_column() const;
   
   /**
      Sprawdza, czy ta droga nie stanowi odwrotności innej.
      @param inna droga, która kończy się tam, gdzie zaczyna się ta droga
      @return wartość true, jeśli inna droga jest odwrotnością tej drogi
   */
   bool is_opposite(const Path& other) const;

   /**
      Wyświetla reprezentację tej drogi w postaci ciągu.
   */
   void print() const;

 private:
   int starting_row;
   int starting_column;
   int starting_direction;
   int ending_row;
   int ending_column;
   int ending_direction;
};

#endif

