#ifndef STACK_H
#define STACK_H

#include <string>

using namespace std;

class Stack
{
public:   
   /** 
      Konstruuje pusty stos.
   */
   Stack();

   /**
      Dodaje element na szczyt stosu.
      @param element dodawany element
   */
   void push(string element);

   /**
      Zwraca element ze szczytu stosu.
      @return element ze szczytu
   */
   string top() const;

   /**
      Usuwa element ze szczytu stosu.
   */
   void pop();

   /**
      Zwraca liczbę elementów na stosie.
      @return rozmiar
   */
   int size() const;
  
private:
   void grow_if_necessary();
   
   string* buffer;
   int len;
   int capacity;
};

#endif

