#include <iostream>
#include <cstdlib>
#include <ctime>

using namespace std;

/** 
    Pobiera pozycję najmniejszego elementu w pewnym zakresie tablicy.
    @param a tablica
    @param from the początek zakresu
    @param to koniec zakresu
    @return pozycja najmniejszego elementu
    w zakresie a[from]...a[to]
*/
int min_position(int a[], int from, int to)
{  
   int min_pos = from;
   for (int i = from + 1; i <= to; i++)
   {
      if (a[i] < a[min_pos]) { min_pos = i; };
   }
   return min_pos;
}

/**
   Zamienia miejscami dwie liczby całkowite.
   @param x pierwsza liczba całkowita do zamiany
   @param y druga liczba całkowita do zamiany
*/
void swap(int& x, int& y)
{  
   int temp = x;
   x = y;
   y = temp;
}

/** 
   Sortuje tablicę przy użyciu algorytmu sortowania przez wybieranie.
   @param a tablica do posortowania
   @param size liczba elementów tablicy a
*/
void selection_sort(int a[], int size)
{  
   for (int next = 0; next < size - 1; next++)
   {  
      // Znajdź pozycję najmniejszej liczby, począwszy od indeksu next.
      int min_pos = min_position(a, next, size - 1);
      // Zamień miejscami element na pozycji next i najmniejszą liczbę.
      swap(a[next], a[min_pos]);
   }
}

/** 
   Wyświetla wszystkie elementy tablicy.
   @param a tablica do wyświetlenia
   @param size liczba elementów tablicy a
*/
void print(int a[], int size)
{  
   for (int i = 0; i < size; i++)
   {
      cout << a[i] << " ";
   }
   cout << endl;
}

const int MAX_SIZE = 10000000;
int values[MAX_SIZE];

int main()
{  
   srand(time(0));   
   cout << "Rozmiar pierwszej tablicy: ";
   int first_size;
   cin >> first_size;
   cout << "Liczba tablic: ";
   int number_of_arrays;
   cin >> number_of_arrays;
   for (int k = 1; k <= number_of_arrays; k++)
   {
      int size = k * first_size;
      for (int i = 0; i < size; i++)
      {
         values[i] = rand() % 100;
      }
      int before = time(0);
      selection_sort(values, size);
      int after = time(0);
      cout << "Rozmiar: " << size << " Czas wykonania: " << after - before
         << " sekund(y)" << endl;
   }
   return 0;
}

