#include <iostream>
#include <iomanip>

using namespace std;

/**
   Konto w banku, którego saldo zmienia się przy wpłatach i wypłatach.
*/
class BankAccount
{
public:
   /**
      Konstruuje konto bankowe z zerowym saldem.
   */
   BankAccount();

   /**
      Konstruuje konto bankowe z podanym saldem.
      @param initial_balance saldo początkowe
   */
   BankAccount(double initial_balance);

   /**
      Dokonuje wpłaty na konto.
      @param amount kwota wpłaty
   */
   void deposit(double amount);

   /**
      Dokonuje wypłaty z konta lub nalicza karę
      przy braku dostępnych środków.
      @param amount wypłacana kwota
   */
   void withdraw(double amount);

   /**
      Dodaje do konta odsetki.
      @param rate stopa odsetek w procentach
   */
   void add_interest(double rate);

   /**
      Pobiera bieżące saldo konta bankowego.
      @return bieżące saldo
   */
   double get_balance() const;
private:
   double balance;
};


BankAccount::BankAccount()
{
   balance = 0;
}

BankAccount::BankAccount(double initial_balance)
{
   balance = initial_balance;
}

void BankAccount::deposit(double amount)
{
   balance = balance + amount;
}

void BankAccount::withdraw(double amount)
{
   const double PENALTY = 10;
   if (amount > balance)
   {
      balance = balance - PENALTY;
   }
   else
   {
      balance = balance - amount;
   }
}

void BankAccount::add_interest(double rate)
{
   double amount = balance * rate / 100;
   deposit(amount);
}

double BankAccount::get_balance() const
{
   return balance;
}

int main()
{
   BankAccount harrys_account(1000);
   harrys_account.deposit(500);
   harrys_account.withdraw(2000);
   harrys_account.add_interest(1); 
   cout << fixed << setprecision(2) 
      << harrys_account.get_balance() << endl;

   return 0;
}

