#include <cstdlib>
#include <iostream>
#include <string>
#include <vector>

using namespace std;

struct StreetAddress
{
   int house_number;
   string street_name;
};

struct MonthlyTemperatures
{
   string location;
   double values[12];
};

struct Person
{
   string name;
   StreetAddress work_address;
};

// Funkcja pobierająca strukturę

void print_address(StreetAddress address)
{
   cout << address.house_number << " " << address.street_name;
}

// Funkcja zwracająca strukturę

StreetAddress make_random_address()
{
   StreetAddress result;
   result.house_number = 100 + rand() % 100;
   result.street_name = "Main Street";
   return result;
}

int main()
{
   StreetAddress white_house;
   // W celu dostępu do składowych struktury używa się zapisu kropkowego:
   white_house.house_number = 1600;
   white_house.street_name = "Pennsylvania Avenue";

   cout << "white_house: ";
   print_address(white_house);
   cout << endl;

   StreetAddress destination;
   destination = white_house;

   cout << "destination: ";
   print_address(destination);
   cout << endl;

   if (destination.house_number == white_house.house_number
      && destination.street_name == white_house.street_name)
   {
      cout << "Struktura destination jest równa strukturze white_house" << endl;
   }

   cout << endl << "Tablica struktur" << endl;

   const int ROUTE_LENGTH = 4;
   StreetAddress delivery_route[ROUTE_LENGTH];

   delivery_route[0].house_number = 123;
   delivery_route[0].street_name = "Main Street";
   delivery_route[1].house_number = 201;
   delivery_route[1].street_name = "Main Street";
   delivery_route[2].house_number = 420;
   delivery_route[2].street_name = "First Street";
   delivery_route[3] = make_random_address();

   for (int i = 0; i < ROUTE_LENGTH; i++)
   {
      cout << "delivery_route[" << i << "]: ";
      print_address(delivery_route[i]);
      cout << endl;
   }

   cout << endl << "Wektor struktur" << endl;

   vector<StreetAddress> tour_destinations;
   tour_destinations.push_back(white_house);
   StreetAddress jefferson_memorial;
   jefferson_memorial.house_number = 900;
   jefferson_memorial.street_name = "Ohio Drive SW";
   tour_destinations.push_back(jefferson_memorial);

   for (int i = 0; i < tour_destinations.size(); i++)
   {
      cout << "tour_destinations[" << i << "]: ";
      print_address(tour_destinations[i]);
      cout << endl;
   }

   cout << endl << "Struktura zawierająca tablicę" << endl;
   MonthlyTemperatures death_valley_noon;
   death_valley_noon.location = "Furnace Creek";
   death_valley_noon.values[0] = 19;
   death_valley_noon.values[1] = 73;
   death_valley_noon.values[2] = 28;
   death_valley_noon.values[3] = 32;
   death_valley_noon.values[4] = 38;
   death_valley_noon.values[5] = 46;
   death_valley_noon.values[6] = 47;
   death_valley_noon.values[7] = 46;
   death_valley_noon.values[8] = 41;
   death_valley_noon.values[9] = 34;
   death_valley_noon.values[10] = 25;
   death_valley_noon.values[11] = 18;

   cout << "death_valley_noon.location: "
      << death_valley_noon.location << endl;
   cout << "death_valley_noon.values: ";
   for (int i = 0; i < 12; i++)
   {
      cout << death_valley_noon.values[i] << " ";
   }
   cout << endl;

   cout << endl << "Struktura zawierająca strukturę" << endl;

   Person theodore;
   theodore.name = "Theodore Roosevelt";
   theodore.work_address = white_house;
   cout << "theodore.work_address.street_name: "
      << theodore.work_address.street_name << endl;

   return 0;
}

