#include <iostream>
#include <string>
#include <cstdlib>
#include <cctype>

using namespace std;

/**
   Tworzy wersję ciągu zapisaną wielkimi literami.
   @param str ciąg
   @return ciąg, w którym wszystkie znaki ciągu str zostały przekształcone na wielkie
*/
string uppercase(string str)
{
   string result = str; // Utwórz kopię ciągu str
   for (int i = 0; i < result.length(); i++)
   {
      result[i] = toupper(result[i]); // Zamień każdą literę na wielką
   }
   return result;
}

int main()
{
   /*
     Aby wyświetlić wartości znaków w postaci dziesiętnej, należy skonwertować je do typu int.
   */
   cout << "Kilka typowych wartości znaków:" << endl;
   cout << "Litera H: " << static_cast<int>('H') << endl;
   cout << "Cyfra 0: " << static_cast<int>('0') << endl;
   cout << "Znak spacji: " << static_cast<int>(' ') << endl;
   cout << "Znak nowego wiersza: " << static_cast<int>('\n') << endl;
   cout << endl;

   const char* char_pointer = "Hanna";
   cout << "Wskaźnik char_pointer wskazuje znak: " << *char_pointer << endl;
   cout << "A w postacie dziesiętnej: " << static_cast<int>(*char_pointer) << endl;
   cout << "Oto zerowy znak końca: "
      << static_cast<int>(*(char_pointer + 5)) << endl;

   char char_array[] = "Hanna";
   cout << "Oto zerowy znak końca: "
      << static_cast<int>(char_array[5]) << endl;
   char_array[0] = 'p';
   cout << "Teraz tablica char_array zawiera ciąg " << char_array << endl;
   cout << endl;

   string year = "2012"; // Ciąg w stylu C++
   char_pointer = year.c_str(); // Skonwertowany na typ char*
   int y = atoi(char_pointer); // Funkcja atoi wymaga ciągu w stylu C.
   cout << "Obiekt typu string " << year << " po konwersji na typ int: " << y << endl;

   string name = "Hanna";
   string sub3 = name.substr(3, 1);
   char ch3 = name[3];
   cout << "Podciąg o długości 1 na pozycji 3: " << sub3 << endl;
   cout << "Znak na pozycji 3: " << ch3 << endl;
   name[3] = 'k';
   cout << "Po zmianie elementu name[3]: " << name << endl;
   cout << "Wielkimi literami: " << uppercase(name) << endl;
   
   return 0;
}

