#include <iostream>
#include <vector>

using namespace std;

int main()
{
   vector<int> values = {1, 4, 9, 16, 25, 36};

   // W tej pętli zmiennej v jest przypisywany po kolei każdy z elementów wektora.
   for (int v : values)
   {
      cout << v << " ";
   }
   cout << endl;

   // Tutaj zmienna v staje się po kolei referencją do każdej z wartości, co pozwala
   // na modyfikację wektora.
   for (int& v : values)
   {
      v += 1;
   }

   // Zamiast podawać typ elementu można użyć słowa auto.
   for (auto v : values)
   {
      cout << v << " ";
   }
   cout << endl;

   // W razie potrzeby modyfikowania elementów należy użyć wyrażenia auto&.
   for (auto& v : values)
   {
      v += 1;
   }

   // To tradycyjny sposób odwiedzania wszystkich elementów.
   for (int i = 0; i < values.size(); i++)
   {
      cout << values[i] << " ";      
   }
   cout << endl;

   // Pętla for "oparta na zakresie" działa również w przypadku tablic.
   int primes[] = { 2, 3, 5, 7, 11, 13 };
   for (int p : primes)
   {
      cout << p << " ";
   }
   cout << endl;
   
   return 0;
}

