#include <iostream>

using namespace std;

/**
   Generuje serię wyników rzutu kostką dla testów.
   @param values tablica wypełniana wynikami rzutu kostką
   @param size rozmiar tablicy values
*/
void generate_test_values(int values[], int size)
{
   int next = 1;
   for (int i = 0; i < size; i++)
   {
      values[i] = next;
      next++;
      if (next == 6) { next = 1; }
   }
}

/**
   Liczy, ile razy w serii rzutów kostką wystąpiła każda z wartości.
   @param values tablica wyników rzutów kostką. Każdy z elementów jest >= 1 i <= zmiennej faces.
   @param size rozmiar tablicy values
   @param faces liczba ścian kostki
   @param counters tablica liczników o długości faces + 1. Do elementu counters[j]
   wprowadzana jest liczba elementów tablicy values, które są równe j. Element counters[0]
   nie jest używany.
*/
void count_values(int values[], int size, int faces, int counters[])
{
   for (int i = 1; i <= faces; i++) { counters[i] = 0; }
   for (int j = 0; j < size; j++)
   {
      int value = values[j];
      counters[value]++;
   }
}

/**
   Wyświetla tablicę liczników wartości rzutów kostką.
   @param faces liczba ścian kostki
   @param counters tablica liczników o długości faces + 1.
   Element counters[0] nie jest wyświetlany.
*/
void print_counters(int faces, int counters[])
{
   for (int i = 1; i <= faces; i++)
   {
      cout << i << ": " << counters[i] << endl;
   }
}

int main()
{
   const int FACES = 6;
   int counters[FACES + 1];
   const int NUMBER_OF_TOSSES = 12;
   int tosses[NUMBER_OF_TOSSES];

   generate_test_values(tosses, NUMBER_OF_TOSSES);   
   count_values(tosses, NUMBER_OF_TOSSES, FACES, counters);
   print_counters(FACES, counters);
   return 0;
}

