#include <iostream>
#include <vector>

using namespace std;

/**
   Odczytuje sekwencję liczb zmiennoprzecinkowych.
   @return wektor zawierający liczby
*/
vector<double> read_inputs()
{
   vector<double> result;
   cout << "Proszę wprowadzić liczby, W - wyjście:" << endl;
   bool more = true;
   while (more)
   {  
      double input;
      cin >> input;
      if (cin.fail())
      {
         more = false;
      }
      else 
      {
         result.push_back(input);
      }
   }
   return result;
}

/**
   Mnoży wszystkie elementy wektora przez dany czynnik.
   @param values wektor
   @param factor liczba, przez którą mnożony jest każdy z elementów
*/
void multiply(vector<double>& values, double factor)
{
   for (int i = 0; i < values.size(); i++)
   {
      values[i] = values[i] * factor;
   }
}

/**
   Wyświetla elementy tablicy rozdzielone przecinkami.
   @param values wektor
*/
void print(vector<double> values)
{
   for (int i = 0; i < values.size(); i++)
   {
      if (i > 0) { cout << ", "; }
      cout << values[i];
   }
   cout << endl;
}

int main()
{  
   vector<double> values = read_inputs();
   multiply(values, 2);
   print(values);

   return 0;
}

