#include <iostream>
#include <fstream>
#include <string>
#include "hashtable.h"

using namespace std;

/**
   Wczytuje wszystkie wyrazy z pliku do tablicy mieszającej.
   @param filename nazwa pliku, z którego mają być odczytane wyrazy
   @return tablica mieszająca zawierająca wszystkie słowa zawarte w pliku,
   zapisane małymi literami
 */
HashTable read_words(string filename)
{
   ifstream in(filename);
   const int BUCKETS = 101;
   HashTable result(BUCKETS);
   string input;
   while (in >> input)
   {
      // Zanim wyrazy zostaną dodane do słownika, zamień w tekście duże litery na małe i podziel go w miejscach, gdzie nie ma liter.
      string word;
      for (int i = 0; i < input.length(); i++)
      {
         char ch = input[i];
         if ('a' <= ch && ch <= 'z')
         {
            word = word + ch;
         }
         else if ('A' <= ch && ch <= 'Z')
         {
            ch = ch + 'a' - 'A';
            word = word + ch;
         }
         else
         {
            result.insert(word);
            word = "";
         }
      }
      result.insert(word);
   }
   // Do zbioru mógł być wstawiony pusty wyraz, jeśli
   // znaki nie będące literami wystąpiły na początku lub na końcu
   // danych wejściowych.
   result.erase("");

   return result;
}

int main()
{
   HashTable dictionary = read_words("words.txt");
   HashTable book = read_words("alice.txt");
   for (Iterator iter = book.begin(); !iter.equals(book.end()); iter.next())
   {
      if (dictionary.count(iter.get()) == 0)
      {
         cout << iter.get() << endl;
      }
   }
}

