#ifndef FRACTION_H
#define FRACTION_H

#include <iostream>

using namespace std;

class Fraction
{
public:
   /**
      Konstruuje ułamek n / d.
      @param n licznik
      @param d mianownik
   */
   Fraction(int n, int d);
   /**
      Konstruuje ułamek n / 1.
      @param n licznik
   */
   Fraction(int n);
   /**
      Konstruuje ułamek 0 / 1.
   */
   Fraction();
   
   /**
      Oblicza odwrotność tego ułamka.
      @return odwrotność (mianownik / licznik)
   */
   Fraction inverse() const;
   /**
      Wypisuje ten ułamek do strumienia.
      @param out strumień wyjściowy
   */
   void print(ostream& out) const;
   /**
      Odczytuje ułamek ze strumienia i zapisuje go 
      w tym obiekcie.
      @param in strumień wejściowy
   */
   void read(istream& in);

   Fraction operator+(Fraction other) const; 
   Fraction operator*(Fraction other) const;
   bool operator<(Fraction other) const;
private:
   int numerator;
   int denominator;
};

Fraction operator-(Fraction f);
Fraction operator-(Fraction f, Fraction g);
Fraction operator*(int n, Fraction f);
Fraction operator/(Fraction f, Fraction g);
bool operator>(Fraction f, Fraction g);
bool operator<=(Fraction f, Fraction g);
bool operator>=(Fraction f, Fraction g);
bool operator==(Fraction f, Fraction g);
bool operator!=(Fraction f, Fraction g);
ostream& operator<<(ostream& out, Fraction f);
istream& operator>>(istream& in, Fraction& a);
   
#endif

