#include <iostream>
#include <string>
#include <vector>

using namespace std;

/*
   Sprawdza, czy podciąg łańcucha jest palindromem.
   @param s ciąg do sprawdzenia
   @param start indeks pierwszego znaku ciągu
   @param end indeks ostatniego znaku ciągu
   @return wartość true, jeśli podciąg jest palindromem
*/
bool substring_is_palindrome(string s, int start, int end)
{
   // Oddzielny przypadek dla podciągów o długości 0 i 1
   if (start >= end) { return true; }
   if (s[start] == s[end])
   {
      // Sprawdź podciąg, który nie zawiera pierwszej i ostatniej litery.
      return substring_is_palindrome(s, start + 1, end - 1);
   }
   else
   {
      return false;
   }
}   

/**
   Sprawdza, czy ciąg jest palindromem. Palindrom
   czytany od tyłu jest taki sam, np. "rotor" albo "kajak".
   @param s ciąg
   @return wartość true, jeśli ciąg s jest palindromem
*/
bool is_palindrome(string s)
{
   return substring_is_palindrome(s, 0, s.length() - 1);
}

int main()
{
   cout << "Wprowadź ciąg: ";
   string input;
   getline(cin, input);
   cout << input << " to ";
   if (!is_palindrome(input)) { cout << "nie "; }
   cout << "palindrom." << endl;
   return 0;
}

