#include <iostream>
#include <string>
#include <vector>

using namespace std;

/**
   Sprawdza, czy ciąg jest palindromem. Palindrom
   czytany od tyłu jest taki sam, np. "rotor" albo "kajak".
   @param s ciąg
   @return wartość true, jeśli ciąg s jest palindromem
*/
bool is_palindrome(string s)
{
   // Oddzielny przypadek dla najkrótszych ciągów
   if (s.length() <= 1) { return true; }

   // Pobierz pierwszy i ostatni znak, zmieniwszy wielkość liter na małe.
   char first = s[0];
   char last = s[s.length() - 1];

   if (first == last)
   {
      string shorter = s.substr(1, s.length() - 2);
      return is_palindrome(shorter);
   }
   else
   {
      return false;
   }
}

int main()
{
   cout << "Wprowadź ciąg: ";
   string input;
   getline(cin, input);
   cout << input << " to ";
   if (!is_palindrome(input)) { cout << "nie "; }
   cout << "palindrom." << endl;
   return 0;
}

