﻿<#
   .Synopsis
    Sprawdza kraj po adresie IP
   .Description
    Skrypt ten pobiera informacje o kraju wg adresu IP. Używa
    usługi sieciowej, więc musi być podłączony do internetu.
   .Example
    Get-CountryByIP.ps1 -ip 10.1.1.1, 192.168.1.1 -log iplog.txt
    Zapisuje nazwę kraju w pliku %mydocuments%\iplog.txt i drukuje ją na ekranie.
   .Inputs
    [string]
   .OutPuts
    [PSObject]
   .Notes
    NAZWA: Get-CountryByIP.ps1
    AUTOR: Ed Wilson 
    WERSJA: 1.0.0
    DATA EDYCJI 20.8.2009
    SŁOWA KLUCZOWE: New-WebServiceProxy, IP, New-Object, PSObject
   .Link
     Http://www.ScriptingGuys.com
#requires -version 2.0
#>
[CmdletBinding()]
Param(
   [Parameter(Mandatory = $true,Position = 0,ValueFromPipeline = $true)]
   [string[]]$ip, 
   [string]$log = "ipLogFile.txt",
   [string]$folder = "Personal"
)#end param

# *** funkcja ***
Function Get-CountryByIP($IP)
{
 $URI = "http://www.webservicex.net/geoipservice.asmx?wsdl"
 $Proxy = New-WebServiceProxy -uri $URI -namespace WebServiceProxy -class IP
 $RTN = $proxy.GetGeoIP($IP)
 
 $ipReturn = New-Object PSObject -Property @{
    'ip' = $rtn.ip;
    'CountryName' = $rtn.countryname; 
    'CountryCode'=$rtn.countrycode}
 
 $ipReturn
} #end Get-CountryByIP

Function Get-Folder($folderName)
{
 [Environment]::GetFolderPath([environment+SpecialFolder]::$folderName)
} #end funkcja Get-Folder

# *** punkt początkowy skryptu ***

$ip | 
ForEach-Object { Get-CountryByIP -ip $_ } |
Tee-Object -Variable results

$results | 
Out-File -FilePath `
  (Join-Path -Path (Get-Folder -folderName $folder) -childPath $log)