﻿# ------------------------------------------------------------------------
# FindDisabledUserAccounts.ps1
# ed wilson, 28.3.2008
#
# Tworzy egzemplarz klasy .NET DirectoryServices.DirectorySearcher
# do przeszukiwania Active Directory.
# Tworzy filtr w składni LDAP, który jest stosowany do obiektu
# wyszukującego. Jeśli szukana jest tylko klasa użytkownika, to otrzymywane są
# również konta komputerowe, ponieważ są one derywowane z klasy użytkownika. 
# W związku z tym wykonujemy zapytanie złożone, aby pobrać także osobę.
# Następnie za pomocą metody findall wyszukujemy i pobieramy wszystkich użytkowników.
# Później przy użyciu własności properties wybieramy item, aby otrzymać nazwę 
# distniguishedname każdego użytkownika, a potem przy użyciu tej nazwy wykonujemy
# zapytanie i pobieramy atrybut UAC. Następnie w instrukcji warunkowej 
# wykonujemy logiczne porównanie z wartością 2, aby dowiedzieć się które
# konto jest wyłączone.
#
# ------------------------------------------------------------------------
#Requires -Version 2.0

$filter = "(&(objectClass=user)(objectCategory=person))"
$users = ([adsiSearcher]$Filter).findall()

 foreach($suser in $users)
  {
   "Sprawdzanie $($suser.properties.item(""distinguishedname""))"
   $user = [adsi]"LDAP://$($suser.properties.item(""distinguishedname""))"
  
   $uac=$user.psbase.invokeget("useraccountcontrol")
     if($uac -band 0x2) 
       { write-host -foregroundcolor red "Konto `t jest wyłączone." } 
     ELSE 
       { write-host -foregroundcolor green "Konto `t nie jest wyłączone." }
  } #foreach