﻿Param(
      $filepath = "C:\fso", 
      $path = "C:\fso1\cabfiles",
      [switch]$debug
     )
Function New-DDF($path,$filePath)
{
 $ddfFile = Join-Path -path $filePath -childpath temp.ddf
 Write-Debug "Ścieżka do pliku DDF: $ddfFile"
 $ddfHeader =@"
;*** Plik dyrektyw MakeCAB
;
.OPTION EXPLICIT			
.Set CabinetNameTemplate=Cab.*.cab
.set DiskDirectory1=C:\fso1\Cabfiles
.Set MaxDiskSize=CDROM
.Set Cabinet=on
.Set Compress=on
"@
 Write-Debug "Zapisywanie nagłówka DDF do $ddfFile." 
 $ddfHeader | Out-File -filepath $ddfFile -force -encoding ASCII
 Write-Debug "Generowanie kolekcji plików z $filePath."
 Get-ChildItem -path $filePath | 
 Where-Object { !$_.psiscontainer } |
 Foreach-Object `
  { 
    '"' + $_.fullname.tostring() + '"'  | 
   Out-File -filepath $ddfFile -encoding ASCII -append
  }
 Write-Debug "Plik DDF został utworzony. Wywoływanie funkcji New-Cab."
 New-Cab($ddfFile)
} #end New-DDF

Function New-Cab($ddfFile)
{
 Write-Debug "Rozpoczynanie wykonywania funkcji New-Cab. Plik DDF nazywa się $ddfFile."
 if($debug)
    { makecab /f $ddfFile /V3 }
 Else
    { makecab /f $ddfFile }
} #end New-Cab

# *** punkt początkowy skryptu ***
if($debug) {$DebugPreference = "continue"}
New-DDF -path $path -filepath $filepath
