﻿Function Get-MemberOf
{
 Param ([string]$group,
        [string]$path)
 $user = [System.Security.Principal.WindowsIdentity]::GetCurrent()
 $nt = "System.Security.Principal.NTAccount" -as [type]
 If( $user.Groups.translate($NT) -match "$group" )
   { if(Test-Path -Path $path)
       {
         Add-Content -Path $path -Value "Dodano bzdurną treść.`r`n"
         "Dodano treść do pliku $path."
         Notepad $path
       } #end if Test-Path 
    ELSE
       { "Nie znaleziono pliku $path"} }
 ELSE
 { "Użytkownik $($user.name) nie należy do grupy $group." }
} # end function Get-MemberOf


#Get-Memberof -group bogus -path 'C:\bogus\bogusfile.txt'