﻿function Test-IsAdministrator
{
    <#
    .Synopsis
        Sprawdza, czy użytkownik jest administratorem
    .Description
        Zwraca prawdę, jeśli użytkownik jest administratorem 
        i fałsz w przeciwnym przypadku. 
    .Example
        Test-IsAdministrator
    #>
    param() 
    $currentUser = [Security.Principal.WindowsIdentity]::GetCurrent()
    (New-Object Security.Principal.WindowsPrincipal $currentUser).IsInRole `
    ([Security.Principal.WindowsBuiltinRole]::Administrator)
} #end funkcja Test-IsAdministrator

# *** punkt początkowy skryptu ***
If(-not (Test-IsAdministrator)) { "Ten skrypt wymaga do działania uprawnień administratora." ; exit }
New-EventLog -LogName scripting -Source processAudit
