﻿#============================================================================
#  
# NAZWA: WriteBiosInfoToWord.ps1
# 
# AUTOR: ed wilson , Microsoft 
# DATA: 30.10.2008
# E-MAIL: Scripter@Microsoft.com
# Wersja: 1.0
# 
# Opis: Tworzy nowy dokument tekstowy przy użyciu obiektu word.application.
# Wysyła zapytanie do WMI za pomocą polecenia get-wmiobject.
# Zamienia zwrócone informacje w łańcuch za pomocą polecenia out-string.
# Zapisuje dane w dokumencie programu Word za pomocą polecenia foreach-object.
# 
# Hey Scripting Guy! 11.11.2008
#============================================================================

$class = "Win32_Bios"
$path = "C:\fso\bios"

# Obiekt wdSaveFormat musi być zapisany jako typ referencyjny.
[ref]$SaveFormat = "microsoft.office.interop.word.WdSaveFormat" -as [type]

$word = New-Object -ComObject word.application
$word.visible = $true
$doc = $word.documents.add()
$selection = $word.selection
$selection.typeText("To są informacje z BIOS-u.")
$selection.TypeParagraph()

Get-WmiObject -class $class | 
Out-String |
ForEach-Object { $selection.typeText($_) }
$doc.saveas([ref] $path, [ref]$saveFormat::wdFormatDocument)
$word.quit()