﻿# ------------------------------------------------------------------------
# NAZWA: Get-MicrosoftUpdates.ps1
# AUTOR: ed wilson, Microsoft
# DATA: 25.2.2009
#
# SŁOWA KLUCZOWE: Microsoft.Update.Session, com
#
# UWAGI: Skrypt ten wyświetla listę aktualizacji firmy Microsoft.
# Można wybrać pewną liczbę aktualizacji lub wszystkie
# aktualizacje.
#
# HSG 9.3.2009
# ------------------------------------------------------------------------
Function Get-MicrosoftUpdates
{ 
  Param(
        $NumberOfUpdates,
        [switch]$all
       )
  $Session = New-Object -ComObject Microsoft.Update.Session
  $Searcher = $Session.CreateUpdateSearcher()
  if($all)
    {
      $HistoryCount = $Searcher.GetTotalHistoryCount()
      $Searcher.QueryHistory(1,$HistoryCount)
    } #end if all
  Else 
    { 
      $Searcher.QueryHistory(1,$NumberOfUpdates) 
    } #end else
} #end Get-MicrosoftUpdates

# *** entry point to script ***

# lists the latest update
# Get-MicrosoftUpdates -NumberofUpdates 1 

# lists All updates
Get-MicrosoftUpdates -all