﻿Function Test-Isinrole
{
 <#
    .Synopsis
        Sprawdza czy użytkownik jest w określonej roli.
    .Description
        Zwraca wartość true, jeśli użytkownik jest w danej roli lub false, jeśli nie. 
    .Example
        Test-Isinrole -role Guest
    #>
    Param($roleName)
 $identity = [Security.Principal.WindowsIdentity]::GetCurrent()
 $principal = New-Object Security.Principal.WindowsPrincipal $identity
 $principal.IsInRole([Security.Principal.WindowsBuiltinRole]::$roleName)
}