﻿Function Get-WmiClasses(
                        $class=($paramMissing=$true),
                        $ns="root\cimv2"
                       )
{
<#
  .SYNOPSIS
  Wyświetla listę klas WMI spełniających podane kryteria wyszukiwania
  .EXAMPLE
  Get-WmiClasses -class disk -ns root\cimv2"
  Polecenie to znajduje klasy WMI zawierające w nazwie słowo disk.
  Szukanie klas odbywa się w przestrzeni nazw root\cimv2.
#>

  If($local:paramMissing)
    {
      throw "Sposób użycia: getwmi2 -class <class type> -ns <wmi namespace>"
    } #$local:paramMissing
  "`nKlasy w przestrzeni nazw $ns..."
  Get-WmiObject -namespace $ns -list | 
  where-object {
                 $_.name -match $class -and `
                 $_.name -notlike 'cim*' 
               }
  # mred function
} #end get-wmiclasses
