﻿Param(
      $filepath = "C:\fso", 
      $path = "C:\fso\aCab.cab",
      [switch]$debug
     )
Function New-Cab($path,$files)
{
 $makecab = "makecab.makecab"
 Write-Debug "Ścieżka tworzenia pliku Cab: $path"
 $cab = New-Object -ComObject $makecab
 if(!$?) { $(Throw "Nie udało się utworzyć obiektu $makecab.")}
 $cab.CreateCab($path,$false,$false,$false)
 Foreach ($file in $files)
  {
   $file = $file.fullname.tostring()
   $fileName = Split-Path -path $file -leaf
   Write-Debug "Dodawanie z $file"
   Write-Debug "Nazwa pliku to $fileName"
   $cab.AddFile($file,$filename)
  }
 Write-Debug "Zamykanie pliku .cab $path"
 $cab.CloseCab()
} #end New-Cab

# *** punkt wejściowy skryptu ***
if($debug) {$DebugPreference = "continue"}
$files = Get-ChildItem -path $filePath | Where-Object { !$_.psiscontainer }
New-Cab -path $path -files $files
