﻿Param($action,$value,[switch]$help)
Function GetHelp()
{
  if($help)
  {
   "Wybierz rodzaj konwersji: M (metry), F (stopy) C (stopnie Celsjusza),Fa (stopnie Fahrenheita),Mi(mile),K (kilometry) oraz wartość"
   " Polecenie Convert -a M -v 10 konwertuje 10 metrów na stopy."
  } #end if help
} #end getHelp
Function GetInclude()
{
 $includeFile = "c:\data\scriptingGuys\ConversionFunctions.ps1"
 if(!(test-path -path $includeFile))
   {
    "Nie znaleziono pliku $includeFile"
    Exit
   }
. $includeFile
} #end GetInclude
Function ParseAction()
{ 
 switch ($action)
 {
  "M" { ConvertToFeet($value) }
  "F"  { ConvertToMeters($value) }
  "C" { ConvertToFahrenheit($value) }
  "Fa" { ConvertToCelsius($value) }
  "Mi" { ConvertToKilometers($value) }
  "K"  { ConvertToMiles($value) }
  DEFAULT { "Nieprawidłowa wartość." ; GetHelp ; exit }
 } #end action
} #end ParseAction
# *** punkt wejściowy ***
If($help) { GetHelp ; exit }
if(!$action) { "Nie określono czynności" ; GetHelp ; exit }
GetInclude
ParseAction
