﻿Function New-LocalGroup
{
 <#
   .Synopsis
    Funkcja tworząca grupę lokalną 
   .Description
    Funkcja ta tworzy grupę lokalną
   .Example
    New-LocalGroup -GroupName "mojagrupa" -description "fajni lokalni użytkownicy"
    Tworzy nową grupę lokalną o nazwie mojagrupa z opisem fajni lokalni użytkownicy.
   .Parameter ComputerName
    Nazwa komputera, na którym ma zostać utworzona grupa
   .Parameter GroupName
    Nazwa grupy, która ma zostać utworzona
   .Parameter description
    Opis nowo utworzonej grupy
   .Notes
    NAZWA:  New-LocalGroup
    AUTOR: ed wilson, msft
    DATA EDYCJI: 6.9.2013 10:07:42
    WYMAGANIA: uprawnienia administratora
    SŁOWA KLUCZOWE: zarządzanie kontami lokalnymi, grupy
    HSG: na bazie HSG-06-30-11
   .Link
     Http://www.ScriptingGuys.com/blog
 #>
 [CmdletBinding()]
 Param(
  [Parameter(Position=0,
      Mandatory=$True,
      ValueFromPipeline=$True)]
  [string]$GroupName,
  [string]$computerName = $env:ComputerName,
  [string]$description = "Utworzono za pomocą PowerShell",
  [switch]$whatif)

  If($whatif) 
  {
   "WHATIF: Tworzenie nowej lokalnej grupy $groupName z opisem $description na komputerze $computername."
   Return
  } #end Whatif
  $adsi = [ADSI]"WinNT://$computerName"
  $objgroup = $adsi.Create("Group", $groupName)
  $objgroup.SetInfo()
  $objgroup.description = $description
  $objgroup.SetInfo()
 
} #end funkcja New-LocalGroup
