﻿Function Get-IPObject
{
 Param ([bool]$IPEnabled = $true)
  Get-WmiObject -class Win32_NetworkAdapterConfiguration -Filter "IPEnabled = $IPEnabled"
} #end Get-IPObject

Function Format-IPOutput
{
 Param ($IP)
 "Adres IP: " + $IP.IPAddress[0]
 "Podsieć: " + $IP.IPSubNet[0]
 "Brama: " + $IP.DefaultIPGateway
 "Serwer DNS: " + $IP.DNSServerSearchOrder[0]
 "FQDN: " + $IP.DNSHostName + "." + $IP.DNSDomain
} #end Format-IPOutput

Function Format-NonIPOutput
{ 
 Param ($IP)
 Begin { "Index #  Description" }
 Process {
  ForEach ($i in $ip)
  {
   Write-Host $i.Index `t $i.Description
  } #end ForEach
 } #end Process
} #end Format-NonIPOutPut

# *** punkt wejściowy ***
$IPEnabled = $false
$ip = Get-IPObject -IPEnabled $IPEnabled
If($IPEnabled) { Format-IPOutput($ip) }
ELSE { Format-NonIPOutput($ip) }
