﻿$errorActionPreference = "SilentlyContinue"
$error.Clear()
$startTime = $endTime = $Message = $logResults = $null

$logDir = "c:\fso"
if(-not(Test-Path -path $logdir)) 
  { New-Item -Path $logdir -ItemType directory | Out-Null }
$logonLog = Join-Path -Path $logDir -ChildPath "logonlog.txt"

$startTime = (Get-Date).tostring()
$WshNetwork = New-Object -ComObject wscript.network
$WshNetwork.MapNetworkDrive("f:","\\berlin\studentShare")
$message += "`r`nMapowanie dysku f na udział \\berlin\student `r`n$($error[0])"
$WshNetwork.SetDefaultPrinter("berlinPrinter")
$message += "`r`nUstawianie domyślnej drukarki na berlinPrinter `r`n$($error[0])"

$endTime = (Get-Date).tostring()
$logResults = @"
**Rozpoczęcie wykonywania skryptu: $($MyInvocation.InvocationName) $startTime.
 $message
**Koniec skryptu logowania $endTime. 
**Czas wykonywania skryptu w sekundach: $((New-TimeSpan -Start $startTime `
  -End $endTime).totalSeconds).
"@
$logResults > $logonLog