﻿Function Set-LocalGroup
{
  <#
   .Synopsis
    Funkcja dodająca i usuwająca lokalnego użytkownika do lokalnej grupy 
   .Description
    Funkcja ta dodaje lub usuwa lokalnego użytkownika z lokalnej grupy
   .Example
    Set-LocalGroup -username "ed" -groupname "administrators" -add
    Przypisuje lokalnego użytkownika o nazwie ed do lokalnej grupty administratorów
   .Example
    Set-LocalGroup -username "ed" -groupname "administrators" -remove
    Usuwa lokalnego użytkownika o nazwie ed z lokalnej grupy administratorów
   .Parameter username
    Nazwa lokalnego użytkownika
   .Parameter groupname
    Nazwa grupy lokalnej
   .Parameter ComputerName
    Nazwa komputera
   .Parameter add
    Powoduje dodanie użytkownika przez funkcję
   .Parameter remove
    Powoduje usunięcie użytkownika przez funkcję
   .Notes
    NAZWA:  Set-LocalGroup
    AUTOR: ed wilson, msft
    DATA EDYCJI: 6.9.2013 10:23:53
    WYMAGANIA: uprawnienia administratora
    SŁOWA KLUCZOWE: zarządzanie kontami lokalnymi, użytkownicy, grupy
    HSG: HSG-06-30-11
   .Link
     Http://www.ScriptingGuys.com/blog
 #Requires -Version 2.0
 #>
 [CmdletBinding()]
 Param(
  [Parameter(Position=0,
      Mandatory=$True,
      ValueFromPipeline=$True)]
  [string]$userName,
  [Parameter(Position=1,
      Mandatory=$True,
      ValueFromPipeline=$True)]
  [string]$GroupName,
  [string]$computerName = $env:ComputerName,
  [Parameter(ParameterSetName='addUser')]
  [switch]$add,
  [Parameter(ParameterSetName='removeuser')]
  [switch]$remove
 )
 Write-Verbose "Łączenie się z grupą $GroupName na komputerze $computerName"
 $group = [ADSI]"WinNT://$ComputerName/$GroupName,group"
 if($add)
  {
  Write-Debug "Przygotowywanie się do dodania użytkownika $userName do grupy $groupName"
  Write-Verbose "Przygotowywanie się do dodania użytkownika $userName do grupy $groupName"
   $group.add("WinNT://$ComputerName/$UserName")
  }
  if($remove)
   {
    Write-Debug "Przygotowywanie się do usunięcia użytkownika $userName z grupy $groupName"
    Write-Verbose "Przygotowywanie się do usunięcia użytkownika $userName z grupy $groupName"
   $group.remove("WinNT://$ComputerName/$UserName")
   }
} #end funkcja Set-LocalGroup