﻿# ------------------------------------------------------------------------
# NAZWA: GetProcessesDisplayTempFile.ps1
# AUTOR: ed wilson, Microsoft
# DATA: 4/4/2009
# WERSJA: 1.0
#
# SŁOWA KLUCZOWE: [io.path], GetTempFileName, out-null
#
# UWAGI: Skrypt ten tworzy plik tymczasowy,
# pobiera kolekcję danych dotyczących procesu i zapisuje 
# ją w pliku tymczasowym. Następnie wyświetla te informacje
# w Notatniku i po zakończeniu usuwa ten plik tymczasowy. 
#
# ------------------------------------------------------------------------
# Funkcja ta tworzy nazwę pliku jak i sam plik.
$tempFile = [io.path]::GetTempFileName()
Get-Process >> $tempFile
# Przekazanie przez potok nazwy pliku Notatnika do polecenia Out-Null
# powoduje zatrzymanie wykonywania skryptu.
Notepad $tempFile | Out-Null
# Po zamknięciu pliku, zostaje on usunięty.
Remove-Item $tempFile