
# How can I make sure an OU is empty before I delete it?

$ouPath= "LDAP://XFilesServer/ou=test,DC=FBI,DC=net"
$ou = new-object system.directoryservices.directoryEntry($ouPath)
$ou.PSbase.Parent.PSbase.Children.Remove($ou)

exit

# How can you reset the password for an existing user?

$Path= "LDAP://XFilesServer1/cn=Walter Skinner,OU=Directors,DC=FBI,DC=net"
$user = New-Object Directoryservices.DirectoryEntry($Path)
$user.SetPassword("secret-123")

# How can you rename an existing user?

$Path= "LDAP://XFilesServer1/CN=Walter Skinner,OU=Directors,DC=FBI,DC=net"
$user = new-object system.directoryservices.directoryEntry($Path)
$user.PSBase.Rename("cn=Walter S. Skinner")
"User has been renamed!"

# How can you delete an existing user?

$Path= "LDAP://XFilesServer1/CN=Walter S. Skinner,OU=Directors,DC=FBI,DC=net"
$user = new-object system.directoryservices.directoryEntry($Path)
if ([system.directoryservices.directoryEntry]::Exists($Path))
{
"User exists and will be deleted now!"
$user.PSBase.DeleteTree()
}
else
{
"User does not exist!"
}
