
function Get-IsInstall($Aplikacja, $Komputer)
{
$a = (Get-WmiObject -Class Win32_Product -Filter "Name='$Aplikacja'" -Computer $Komputer) 
return ($a -ne $null)
}

$Nazwa = "Hello World VB.NET"
$Komputer = "QUAD"
$Pakiet = "c:\demo\WPS\B_Software\Setup_for_HelloWorld_VBNET.msi"

"-----------------------------------------------------------------"
"Testowanie instalowania i odinstalowywania aplikacji..." + $Nazwa
"-----------------------------------------------------------------"

"Stan pocztkowy: zainstalowana?: " + (Get-IsInstall $Nazwa $Komputer)

"Rozpoczynanie instalacji " + $Pakiet
$Wynik = ([WMIClass] "Win32_Product").Install($Pakiet).Returnvalue
if ($Wynik -ne 0) { Write-Error "Bd: $Wynik"; Exit } 
"Instalacja zakoczona!"

"Stan poredni: czy aplikacja jest zainstalowana?: " + (Get-IsInstall $Nazwa $Komputer)

"Rozpoczynanie odinstalowywania..."
$Wynik = (Get-WmiObject -Class Win32_Product -Filter "Name='$Nazwa'" -ComputerName $Komputer).Uninstall().Returnvalue
if ($Wynik -ne 0) { Write-Error "Bd: $Wynik"; Exit } 
"Zakoczono odinstalowywanie!"

"Stan kocowy: czy aplikacja jest zainstalowana?: " + (Get-IsInstall $Nazwa $Komputer)
