# Create a GPO link

trap {
	Write-Error ("BD: " + $_.Exception.Message)
	if ($_.Exception.InnerException -ne $null) { Write-Error ("BD: " + $_.Exception.InnerException.Message) }
	exit
}

# Parametry
$Domena = "dtest.windowsservernet.com"
$Kontener = "ou=Kierownictwo, dc=dtest, dc=windowsservernet, dc=com"
$GPOID = "{31B2F340-016D-11D2-945F-00C04FB984F9}"

# Tworzenie obiektu
$gpm = New-Object -ComObject "GPMGMT.GPM"

# Dane domeny
$Domena = $GPM.GetDomain($Domena, "", $GPM.GetConstants().UseAnyDC)

# Dane kontenera
$Kontener = $Domena.GetSOM($Kontener)

# Obiekt GPO
$GPO = $Domena.GetGPO($GPOID)

# Powizanie
$Link = $Kontener.CreateGPOLink(-1, $GPO)

"Obiekt GPO zosta przypisany!"
