#######################################
# Skrypt PowerShella
# (C) dr Holger Schwichtenberg
########################################

# Dodawanie wpisu ACE do listy ACL: przyznawanie prawa odczytu 

# Parametry
$KATALOG = "h:\projekty"
$UYTKOWNIK = "HS"

# Pobieranie ACL
$ACL = Get-Acl  $KATALOG

"Lista ACL przed:"
$acl | format-list

# Definiowanie ACE
$Uprawnienia = [System.Security.AccessControl.FileSystemRights] "ReadData, ReadExtendedAttributes, ReadAttributes, ReadPermissions"
$Typ=[System.Security.AccessControl.AccessControlType]::Allow
$Dziedziczenie=[System.Security.AccessControl.InheritanceFlags]::ContainerInherit `
        -bor [System.Security.AccessControl.InheritanceFlags]::ObjectInherit
$Propagacja=[System.Security.AccessControl.PropagationFlags]::InheritOnly
$ACE = new-object System.Security.AccessControl.FileSystemAccessRule `
($UYTKOWNIK,$Uprawnienia,$Dziedziczenie,$Propagacja,$Typ)

# Dodawanie ACE do ACL
$ACL.AddAccessRule($ACE)

# Zapisywanie ACL 
Set-Acl -AclObject $ACL -Path $KATALOG

# Ponowne pobieranie ACL
$ACL = Get-Acl  $KATALOG

"Lista ACL po:"
$acl | format-list
