###########################################
# Tworzenie grupy udziaw z okrelonymi uprawnieniami
# (C) dr Holger Schwichtenberg, www.IT-Visions.de
###########################################

# Parametry
$Komputer = "E01"
$NazwaUdziau = "klienci"
$cieka = "j:\klienci"
$Komentarz = "Dokumenty klientw"

# Constants
$SHARE_READ = 1179817
$SHARE_CHANGE = 1245462
$SHARE_FULL = 2032127
$SHARE_NONE = 1

$ACETYPE_ACCESS_ALLOWED = 0
$ACETYPE_ACCESS_DENIED = 1
$ACETYPE_SYSTEM_AUDIT = 2

$ACEFLAG_INHERIT_ACE = 2
$ACEFLAG_NO_PROPAGATE_INHERIT_ACE = 4
$ACEFLAG_INHERIT_ONLY_ACE = 8
$ACEFLAG_INHERITED_ACE = 16
$ACEFLAG_VALID_INHERIT_FLAGS = 31
$ACEFLAG_SUCCESSFUL_ACCESS = 64
$ACEFLAG_FAILED_ACCESS = 128

# Pobieranie uytkownika
function New-Trustee($Domena, $Uytkownik)
{
$Konto = new-object system.security.principal.ntaccount("pawelkor")
$SID = $Konto.Translate([system.security.principal.securityidentifier])
$konto_uytkownika = [ADSI] ("WinNT://" + $Domena + "/" + $Uytkownik)
$mc = [WMIClass] "Win32_Trustee"
$t = $MC.CreateInstance()
$t.Domain = $Domena
$t.Name = $Uytkownik
$t.SID = $konto_uytkownika.Get("ObjectSID")
return $t
}

# Tworzenie ACE
function New-ACE($Domena, $Uytkownik, $Dostp, $Typ, $Znaczniki)
{
$mc = [WMIClass] "Win32_Ace"
$a = $MC.CreateInstance()
$a.AccessMask = $Dostp
$a.AceFlags = $Znaczniki
$a.AceType = $Typ
$a.Trustee = New-Trustee $Domena $Uytkownik
return $a
}

# Tworzenie deskryptora zabezpiecze
function Get-SD
{

$mc = [WMIClass] "Win32_SecurityDescriptor"
$sd = $MC.CreateInstance()
$ACE1 = New-ACE "ITV" "Programici" $SHARE_READ  $ACETYPE_ACCESS_ALLOWED $ACEFLAG_INHERIT_ACE  
$ACE2 = New-ACE "ITV" "Konsultanci" $SHARE_FULL $ACETYPE_ACCESS_ALLOWED $ACEFLAG_INHERIT_ACE 
$ACE3 = New-ACE "ITV" "Kierownictwo" $SHARE_FULL $ACETYPE_ACCESS_ALLOWED $ACEFLAG_INHERIT_ACE  
[System.Management.ManagementObject[]] $DACL = $ACE1 , $ACE2, $ACE3


$sd.DACL = $DACL
return $sd
}

# przed
"Przed:"
Get-WmiObject Win32_Share -Filter "Name='$NazwaUdziau'"

get-WmiObject Win32_Share -Filter "Name='$NazwaUdziau'" | foreach-object { $_.Delete() }

# Tworzenie obiektu Win32_Share
$MC = [WMIClass] "ROOT\CIMV2:Win32_Share" 
$Dostp = Get-SD
$R = $mc.Create($cieka, $NazwaUdziau, 0, 10, $Komentarz, "", $Dostp)

# Wynik
if ( $R.ReturnValue -ne 0) { Write-Error ("Bd przy tworzeniu udziau: " +
$R.ReturnValue); Exit}
"Udzia zosta utworzony!"

# po
"Po:"

get-WmiObject Win32_Share -Filter "Name='$NazwaUdziau'" | foreach { $_.GetAccessMask()  } | gm 
