﻿using Microsoft.Phone.Controls;
using System.Threading;
using Microsoft.Phone.Reactive;
using System.Device.Location;
using System.Collections.Generic;
using System;

namespace GeoCoordinateWatcherDemo
{
    public partial class MainPage : PhoneApplicationPage
    {
        GeoCoordinateWatcher _geoCoordinateWatcher; 

        public MainPage()
        {
            InitializeComponent();

            // zinicjowanie obiektu GeoCoordinateWatcher
            _geoCoordinateWatcher = new GeoCoordinateWatcher();

            // zdarzenie PositionChanged dostarcza informacje z odbiornika GPS
            _geoCoordinateWatcher.PositionChanged += 
                new EventHandler<GeoPositionChangedEventArgs<GeoCoordinate>>
                    (_geoCoordinateWatcher_PositionChanged);

            // Wątek simulateGpsThread uruchamia rozszerzenie Reactive Extension, w którym
            // metoda EmulatePositionChangedEvents będzie dostarczała dane 
            // do zdarzenia PositionChanged
            Thread simulateGpsThread = new Thread(SimulateGPS);
            simulateGpsThread.Start();
        }

        // Rozszerzenie Reactive Extension przechwytujące zdarzenie _geoCoordinateWatcher_PositionChanged
        // w celu wygenerowania danych GPS
        private void SimulateGPS()
        {
            var position = GPSPositionChangedEvents().ToObservable();
            position.Subscribe(evt => _geoCoordinateWatcher_PositionChanged(null, evt));
        }

        private static IEnumerable<GeoPositionChangedEventArgs<GeoCoordinate>> GPSPositionChangedEvents()
        {
            Random random = new Random();

            // dostarczenie danych GPS
            while (true)
            {
                Thread.Sleep(TimeSpan.FromSeconds(2));

                // wygenerowanie losowych wartoścu długości i szerokości 
                double latitude = (random.NextDouble() * 180.0) - 90.0; // długość pomiędzy -90 i 90
                double longitude = (random.NextDouble() * 360.0) - 180.0; // szerokość pomiędzy -180 i 180

                yield return new GeoPositionChangedEventArgs<GeoCoordinate>(
                  new GeoPosition<GeoCoordinate>(DateTimeOffset.Now, new GeoCoordinate(latitude, longitude)));
            }
        }


        private void _geoCoordinateWatcher_PositionChanged(object sender
            , GeoPositionChangedEventArgs<GeoCoordinate> e)
        {
            this.Dispatcher.BeginInvoke(() =>
            {
                txtLatitude.Text = e.Position.Location.Latitude.ToString();
                txtLongitude.Text = e.Position.Location.Longitude.ToString();
            });
        }
    }
}