﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;

namespace CalculatorService
{
    // UWAGA: Polecenie "Rename" z menu "Refactor" pozwala na zmianę nazwy klasy "Service1" jednocześnie w kodzie i w pliku konfiguracyjny.
    public class Service1 : IService1
    {
        public int Add(object x, object y)
        {
            int xValue = CheckValue(x);
            int yValue = CheckValue(y);

            return xValue + yValue;
        }

        private int CheckValue(object value)
        {
            int convertedValue = -1;
            if (value == null)
            {
                throw new ArgumentNullException("value");
            }
            else if (!int.TryParse(value.ToString(), out convertedValue))
            {
                throw new ArgumentException(string.Format("Wartość '{0}' nie jest liczbą całkowitą.", value));
            }

            return convertedValue;
        }
    }
}
