﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Notification;
using System.Diagnostics;

namespace PNClient
{
    public partial class MainPage : PhoneApplicationPage
    {
        Uri channelUri;

        public Uri ChannelUri
        {
            get { return channelUri; }
            set
            {
                //wyrejestruj poprzedni identyfikator URI (na serwerze)
                if (channelUri!=null)
                    UnregisterUriFromServer(channelUri);

                //zarejestruj nowy identyfikator URI na serwerze
                RegisterUriWithServer(value);

                channelUri = value;
                OnChannelUriChanged(value);
            }
        }

        private void OnChannelUriChanged(Uri value)
        {
            Dispatcher.BeginInvoke(() =>
            {
                txtURI.Text = "zmiana URI na " + value.ToString();
            });

            Debug.WriteLine("zmiana URI na " + value.ToString());
        }

        public MainPage()
        {
            InitializeComponent();            
        }

        private void btnCreateChannel_Click(object sender, RoutedEventArgs e)
        {
            SetupChannel();
        }

        private void SetupChannel()
        {
            HttpNotificationChannel httpChannel = null;
            string channelName = "DemoChannel";

            try
            {
                //Pobranie informacji o istniejącym kanale, jeśli takowy istnieje.
                httpChannel = HttpNotificationChannel.Find(channelName);
                if (httpChannel != null)
                {
                    //Jeśli przejęcie kanału jest niemożliwe, należy go zamknąć i ustanowić ponownie.
                    if (httpChannel.ChannelUri == null)
                    {
                        httpChannel.UnbindToShellToast();
                        httpChannel.Close();
                        SetupChannel();
                        return;
                    }
                    else
                    {
                        ChannelUri = httpChannel.ChannelUri;
                    }
                    BindToShell(httpChannel);
                }
                else
                {

                    httpChannel = new HttpNotificationChannel(channelName);
                    httpChannel.ChannelUriUpdated += new EventHandler<NotificationChannelUriEventArgs>(httpChannel_ChannelUriUpdated);
                    httpChannel.ShellToastNotificationReceived+=new EventHandler<NotificationEventArgs>(httpChannel_ShellToastNotificationReceived);
                    httpChannel.HttpNotificationReceived+=new EventHandler<HttpNotificationEventArgs>(httpChannel_HttpNotificationReceived);
                    httpChannel.ErrorOccurred += new EventHandler<NotificationChannelErrorEventArgs>(httpChannel_ExceptionOccurred);

                    httpChannel.Open();
                    BindToShell(httpChannel);
                }
            }
            catch (Exception ex)
            {
                Debug.WriteLine("Wyjątek wygenerowany podczas ustanawiania kanału komunikacyjnego: " + ex.ToString());
            }
        }

        void httpChannel_ShellToastNotificationReceived(object sender, NotificationEventArgs e)
        {
            Dispatcher.BeginInvoke(() =>
            {
                txtURI.Text = "Odebrane powiadomienie: ";
                if (e.Collection != null)   
                {   
                    Dictionary<string, string> collection = (Dictionary<string, string>)e.Collection;   
                    System.Text.StringBuilder messageBuilder = new System.Text.StringBuilder();   
                    foreach (string elementName in collection.Keys)   
                    {
                        txtURI.Text+= string.Format("Klucz: {0}, Wartość: {1}\r\n", elementName, collection[elementName]);   
                    }
                }   
            });
        }

        private static void BindToShell(HttpNotificationChannel httpChannel)
        {
            try
            {
                //wiązanie powiadomień wyskakujących
                httpChannel.BindToShellToast();
                //wiązanie powiadomień kafelkowych
                httpChannel.BindToShellTile();
            }
            catch (Exception ex)
            {
                Debug.WriteLine("Wyjątek wygenerowany podczas wiązania wiązania powiadomień " + ex.ToString());
            }
        }

        void httpChannel_ExceptionOccurred(object sender, NotificationChannelErrorEventArgs e)
        {
            //Wyświetlenie komunikatu o błędzie
            Debug.WriteLine ( e.Message);
        }

        void httpChannel_ChannelUriUpdated(object sender, NotificationChannelUriEventArgs e)
        {
            //Pobranie nowego (lub zaktualizowanego) identyfikatora URI
            ChannelUri = e.ChannelUri;
        }

        private void RegisterUriWithServer(Uri newChannelUri)
        {
            //Zapisany na stałe adres usługi - musi zostać zmieniony na adres rzeczywistej usługi REST WCF
            string baseUri = "http://localhost/RegistrationService/Register?uri={0}";
            string theUri = String.Format(baseUri, newChannelUri.ToString());
            WebClient client = new WebClient();
            client.DownloadStringCompleted += (s, e) =>
            {
                if (e.Error == null)
                    Dispatcher.BeginInvoke(() => {
                        txtURI.Text = "zmiana URI na " + newChannelUri.ToString();
                    });
                else
                    Dispatcher.BeginInvoke(() =>
                    {
                        txtURI.Text = "błąd rejestracji " + e.Error.Message;
                    });
            };
            client.DownloadStringAsync(new Uri(theUri));

        }

        private void UnregisterUriFromServer(Uri oldChannelUri)
        {
            //Zapisany na stałe adres usługi - musi zostać zmieniony na adres rzeczywistej usługi REST WCF
            string baseUri = "http://localhost/RegistrationService/Unregister?uri={0}";
            string theUri = String.Format(baseUri, oldChannelUri.ToString());
            WebClient client = new WebClient();
            client.DownloadStringCompleted += (s, e) =>
            {
                if (e.Error == null)
                    Dispatcher.BeginInvoke(() =>
                    {
                        txtURI.Text = "wyrejestrowany URI " + oldChannelUri.ToString();
                    });
                else
                    Dispatcher.BeginInvoke(() =>
                    {
                        txtURI.Text = "błąd wyrejestrowania " + e.Error.Message;
                    });
            };
            client.DownloadStringAsync(new Uri(theUri));
        }

        // Pobranie niesformatowanego powiadomienia
        // Niesformatowane powiadomienia są dostarczane do aplikacji tylko wtedy, gdy pracuje jako proces pierwszoplanowy.
        // Jeśli aplikacja nie pracuje na pierwszym planie, powiadomienie jest ignorowane.
        void httpChannel_HttpNotificationReceived(object sender, HttpNotificationEventArgs e)
        {
            if (e.Notification.Body != null && e.Notification.Headers != null)
            {
                System.IO.StreamReader reader = new System.IO.StreamReader(e.Notification.Body);
                Dispatcher.BeginInvoke(() =>
                {
                    txtURI.Text = "Odebrane niesformatowane powiadomienie";
                });
            }
        }
    }
}
