using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.Diagnostics;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.StorageClient;

namespace Aplikacja
{
    public class WebRole : RoleEntryPoint
    {
        public override bool OnStart()
        {
            //Utworzenie obiektu podstawowego komunikacji z Azure Storage
            //CloudStorageAccount wskazuje na lokalny emulator Azure Storage
            CloudStorageAccount csa = CloudStorageAccount.Parse(RoleEnvironment.GetConfigurationSettingValue("StorageCredentials"));
            //utworzenie klienta Azure Queues na podstawie CloudStorageAccount
            CloudQueueClient cqc = csa.CreateCloudQueueClient();
            //Dziki CloudQueue mona pobra referencj do kolejki (nawet nieistniejcej!)
            CloudQueue inputQueue = cqc.GetQueueReference("inputqueue");
            //Metoda CreateIfNotExist gwarantuje utworzenie kolejki
            inputQueue.CreateIfNotExist();
            CloudQueue outputQueue = cqc.GetQueueReference("outputqueue");
            outputQueue.CreateIfNotExist();
            //utworzenie klienta Azure Tables na podstawie CloudStorageAccount
            CloudTableClient ctc = csa.CreateCloudTableClient();
            //Metoda CreateIfNotExist gwarantuje utworzenie tabeli
            ctc.CreateTableIfNotExist("last");

            return base.OnStart();
        }

    }
}
